import { Controller, Delete, Get } from '@nestjs/common';
import { MqttService } from './mqtt.service';
import {
  ApiTags,
  ApiResponse,
  ApiOperation,
  ApiProduces,
} from '@nestjs/swagger';

/**
 * Controller to handle MQTT-related requests.
 * @class MqttClientController
 */
@Controller('mqtt/client')
@ApiTags('MQTT Client Management')
export class MqttClientController {
  constructor(private readonly mqttService: MqttService) {}

  /**
   * Endpoint to get the status of the MQTT client.
   * @description This is for testing purposes only. It returns the current status.
   * @return {string} Connection status.
   */
  @Get('status')
  @ApiOperation({ summary: 'Get the status of the MQTT client' })
  @ApiProduces('text/plain')
  @ApiResponse({ status: 200, description: 'Client status' })
  getClientStatus(): string {
    return this.mqttService.getClientStatus();
  }

  /**
   * Endpoint to disconnect the MQTT client.
   * @description This is for testing purposes only. It disconnects the client.
   * @return {string} Disconnection status.
   */
  @Delete('disconnect')
  @ApiOperation({ summary: 'Disconnect the MQTT client' })
  @ApiProduces('text/plain')
  @ApiResponse({ status: 200, description: 'Client disconnected' })
  deleteClient(): string {
    this.mqttService.mqttDisconnect();
    return `Disconnected from client`;
  }

  /**
   * Endpoint to connect the MQTT client.
   * @description This is for testing purposes only. It connects the client.
   * @return {string} Connection status.
   */
  @Get('connect')
  @ApiOperation({ summary: 'Connect the MQTT client' })
  @ApiProduces('text/plain')
  @ApiResponse({ status: 200, description: 'Client connected' })
  addClient(): string {
    this.mqttService.mqttConnect();
    return `Connected to client`;
  }
}
